/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.explicitroutesubobject.type;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.explicitroutesubobject.Type;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of ipv6Address.
 */
public interface Ipv6Address extends Type, Augmentable  {

    /**
     * Identify the leaf of Ipv6Address.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents v6Address.
         */
        V6ADDRESS(1),
        /**
         * Represents v6PrefixLength.
         */
        V6PREFIXLENGTH(2),
        /**
         * Represents v6Loose.
         */
        V6LOOSE(3);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute v6Address.
     *
     * @return v6Address value of v6Address
     */
    org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Ipv6Address v6Address();

    /**
     * Returns the attribute v6PrefixLength.
     *
     * @return v6PrefixLength value of v6PrefixLength
     */
    short v6PrefixLength();

    /**
     * Returns the attribute v6Loose.
     *
     * @return v6Loose value of v6Loose
     */
    boolean v6Loose();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute v6Address.
     *
     * @param v6Address value of v6Address
     */
    void v6Address(org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Ipv6Address v6Address);

    /**
     * Sets the attribute v6PrefixLength.
     *
     * @param v6PrefixLength value of v6PrefixLength
     */
    void v6PrefixLength(short v6PrefixLength);

    /**
     * Sets the attribute v6Loose.
     *
     * @param v6Loose value of v6Loose
     */
    void v6Loose(boolean v6Loose);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}