/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfnetwork.rev20151208.yrtietfnetwork.networks.network;

import org.onosproject.yang.gen.v1.yrtietfnetwork.rev20151208.yrtietfnetwork.NetworkId;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of supportingNetwork.
 */
public class SupportingNetworkKeys implements KeyInfo<DefaultSupportingNetwork> {
    protected NetworkId networkRef;
    /**
     * Returns the attribute networkRef.
     *
     * @return networkRef value of networkRef
     */
    public NetworkId networkRef() {
        return networkRef;
    }

    /**
     * Sets the value to attribute networkRef.
     *
     * @param networkRef value of networkRef
     */
    public void networkRef(NetworkId networkRef) {
        this.networkRef = networkRef;
    }


    @Override
    public int hashCode() {
        return Objects.hash(networkRef);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SupportingNetworkKeys) {
            SupportingNetworkKeys other = (SupportingNetworkKeys) obj;
            return
                Objects.deepEquals(networkRef, other.networkRef);
        }
        return false;
    }
}