/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkunderlayattributes.underlaybackuppath;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.explicitroutesubobject.Type;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of pathElement.
 */
public interface PathElement extends Augmentable  {

    /**
     * Identify the leaf of PathElement.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents pathElementId.
         */
        PATHELEMENTID(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute pathElementId.
     *
     * @return pathElementId value of pathElementId
     */
    long pathElementId();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute type.
     *
     * @return type value of type
     */
    Type type();

    /**
     * Sets the attribute pathElementId.
     *
     * @param pathElementId value of pathElementId
     */
    void pathElementId(long pathElementId);

    /**
     * Sets the attribute type.
     *
     * @param type value of type
     */
    void type(Type type);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}