/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes;

import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.ipversion.IpVersionEnum;
import java.util.Objects;

/**
 * Represents the implementation of ipVersion.
 */
public final class IpVersion {

    private IpVersionEnum enumeration;

    /**
     * Creates an instance of ipVersion.
     */
    private IpVersion() {
    }

    /**
     * Creates an instance of enumeration.
     *
     * @param enumeration value of enumeration
     */
    public IpVersion(IpVersionEnum enumeration) {
        this.enumeration = enumeration;
    }

    /**
     * Returns the object of ipVersion for type enumeration.
     *
     * @param value value of ipVersion for type enumeration
     * @return ipVersion for type enumeration
     */
    public static IpVersion of(IpVersionEnum value) {
        return new IpVersion(value);
    }

    /**
     * Returns the attribute enumeration.
     *
     * @return enumeration value of enumeration
     */
    public IpVersionEnum enumeration() {
        return enumeration;
    }
    /**
     * Sets the attribute enumeration.
     *
     * @param enumeration value of enumeration
     */
    public void enumeration(IpVersionEnum enumeration) {
        this.enumeration = enumeration;
    }

    @Override
    public int hashCode() {
        return Objects.hash(enumeration);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IpVersion) {
            IpVersion other = (IpVersion) obj;
            return
                Objects.deepEquals(enumeration, other.enumeration);
        }
        return false;
    }

    @Override
    public String toString() {
        return enumeration.toString();
    }
    /**
     * Returns the object of ipVersion fromString input String ipVersion.
     *
     * @param valInString value of input String
     * @return ipVersion
     */
    public static IpVersion fromString(String valInString) {
        try {
            IpVersionEnum tmpVal = IpVersionEnum.of(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
