/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes;

/**
 * Represents the implementation of pathMetricType.
 */
public abstract class PathMetricType {

    /**
     * Returns the attribute path-metric-type.
     *
     * @return path-metric-type value of path-metric-type
     */
    public static String pathMetricTypeToString() {
        return "path-metric-type";
    }

    /**
     * Returns the object of pathMetricType fromString input String pathMetricType.
     *
     * @param valInString value of input String
     * @return pathMetricType
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("path-metric-type")) {
            return PathMetricType.class;
        } else if (valInString.equals("path-metric-te")) {
            return PathMetricTe.class;
        } else if (valInString.equals("path-metric-igp")) {
            return PathMetricIgp.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}