/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.serializers.xml;

import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.dom4j.Element;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.KeyLeaf;
import org.onosproject.yang.model.LeafNode;
import org.onosproject.yang.model.ListKey;
import org.onosproject.yang.model.NodeKey;
import org.onosproject.yang.model.ResourceId;
import org.onosproject.yang.model.SchemaId;
import org.onosproject.yang.runtime.Annotation;
import org.onosproject.yang.runtime.DataNodeListener;
import org.onosproject.yang.serializers.xml.SerializerHandlerFactory;
import org.onosproject.yang.serializers.xml.XmlSerializerException;
import org.onosproject.yang.serializers.xml.XmlSerializerHandler;

class DataNodeXmlListener
implements DataNodeListener {
    private final Stack<Element> elementStack = new Stack();
    private Element rootElement;
    private String xmlData = "";
    private Map<ResourceId, List<Annotation>> annotationMap;
    private ResourceId.Builder rIdBuilder;
    private static final String FORWARD_SLASH = "/";
    private static final String EMPTY_STRING = "";

    DataNodeXmlListener(Map<ResourceId, List<Annotation>> annotations, ResourceId.Builder ridBuilder) {
        this.annotationMap = annotations;
        this.rIdBuilder = ridBuilder;
    }

    public void rootElement(Element rootElement) {
        this.rootElement = rootElement;
    }

    public String xmlData() {
        return this.xmlData;
    }

    public void enterDataNode(DataNode node) {
        if (!DataNodeXmlListener.isRootDataNode(node)) {
            SerializerHandlerFactory factory = SerializerHandlerFactory.instance();
            XmlSerializerHandler handler = factory.getSerializerHandlerForContext(node);
            try {
                if (handler != null) {
                    Element element = handler.processXmlContext(node, this.elementStack);
                    if (this.elementStack.isEmpty()) {
                        this.rootElement(element);
                    }
                    this.elementStack.push(element);
                    ResourceId id = this.getResourceId(node);
                    List<Annotation> annotations = this.annotationMap.get(id);
                    if (annotations != null) {
                        for (Annotation annotation : annotations) {
                            element.addAttribute(annotation.name(), annotation.value());
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new XmlSerializerException(e.getMessage());
            }
            if (handler != null) {
                handler.setXmlValue(node, this.elementStack);
            }
        }
    }

    public void exitDataNode(DataNode dataNode) {
        if (!this.elementStack.isEmpty() && this.elementStack.peek().equals(this.rootElement)) {
            this.xmlData = this.xmlData + this.rootElement.asXML();
        }
        if (!DataNodeXmlListener.isRootDataNode(dataNode)) {
            this.elementStack.pop();
            this.rIdBuilder.removeLastKey();
        }
    }

    private ResourceId getResourceId(DataNode dataNode) {
        SchemaId schemaId = dataNode.key().schemaId();
        switch (dataNode.type()) {
            case MULTI_INSTANCE_LEAF_VALUE_NODE: {
                Object valObject = ((LeafNode)dataNode).value();
                this.rIdBuilder = this.rIdBuilder.addLeafListBranchPoint(schemaId.name(), schemaId.namespace(), valObject);
                break;
            }
            case MULTI_INSTANCE_NODE: {
                List keyLeaves;
                this.rIdBuilder = this.rIdBuilder.addBranchPointSchema(schemaId.name(), schemaId.namespace());
                NodeKey key = dataNode.key();
                if (!(key instanceof ListKey) || (keyLeaves = ((ListKey)key).keyLeafs()) == null) break;
                for (KeyLeaf keyLeaf : keyLeaves) {
                    SchemaId leafSchema = keyLeaf.leafSchema();
                    this.rIdBuilder = this.rIdBuilder.addKeyLeaf(leafSchema.name(), leafSchema.namespace(), keyLeaf.leafValue());
                }
                break;
            }
            case SINGLE_INSTANCE_LEAF_VALUE_NODE: 
            case SINGLE_INSTANCE_NODE: {
                this.rIdBuilder = this.rIdBuilder.addBranchPointSchema(schemaId.name(), schemaId.namespace());
                break;
            }
            default: {
                throw new XmlSerializerException("Unsupported type" + dataNode.type());
            }
        }
        return this.rIdBuilder.build();
    }

    private static boolean isRootDataNode(DataNode node) {
        return node.key().schemaId().name().equals(FORWARD_SLASH);
    }
}

