/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkconfig.bundlestacklevel.component.componentlinks;

import java.util.BitSet;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of componentLink.
 */
public interface ComponentLink extends Augmentable  {

    /**
     * Identify the leaf of ComponentLink.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents sequence.
         */
        SEQUENCE(1),
        /**
         * Represents srcInterfaceRef.
         */
        SRCINTERFACEREF(2),
        /**
         * Represents desInterfaceRef.
         */
        DESINTERFACEREF(3);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute sequence.
     *
     * @return sequence value of sequence
     */
    long sequence();

    /**
     * Returns the attribute srcInterfaceRef.
     *
     * @return srcInterfaceRef value of srcInterfaceRef
     */
    String srcInterfaceRef();

    /**
     * Returns the attribute desInterfaceRef.
     *
     * @return desInterfaceRef value of desInterfaceRef
     */
    String desInterfaceRef();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute sequence.
     *
     * @param sequence value of sequence
     */
    void sequence(long sequence);

    /**
     * Sets the attribute srcInterfaceRef.
     *
     * @param srcInterfaceRef value of srcInterfaceRef
     */
    void srcInterfaceRef(String srcInterfaceRef);

    /**
     * Sets the attribute desInterfaceRef.
     *
     * @param desInterfaceRef value of desInterfaceRef
     */
    void desInterfaceRef(String desInterfaceRef);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}