/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tenodeaugment;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.TeNodeId;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tenodeaugment.te.Config;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tenodeaugment.te.State;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tenodeaugment.te.TunnelTerminationPoint;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of te.
 */
public interface Te extends Augmentable  {

    /**
     * Identify the leaf of Te.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents teNodeId.
         */
        TENODEID(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute teNodeId.
     *
     * @return teNodeId value of teNodeId
     */
    TeNodeId teNodeId();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute config.
     *
     * @return config value of config
     */
    Config config();

    /**
     * Returns the attribute state.
     *
     * @return state value of state
     */
    State state();

    /**
     * Returns the attribute tunnelTerminationPoint.
     *
     * @return tunnelTerminationPoint list of tunnelTerminationPoint
     */
    List<TunnelTerminationPoint> tunnelTerminationPoint();

    /**
     * Sets the attribute teNodeId.
     *
     * @param teNodeId value of teNodeId
     */
    void teNodeId(TeNodeId teNodeId);

    /**
     * Sets the attribute config.
     *
     * @param config value of config
     */
    void config(Config config);

    /**
     * Sets the attribute state.
     *
     * @param state value of state
     */
    void state(State state);

    /**
     * Sets the attribute tunnelTerminationPoint.
     *
     * @param tunnelTerminationPoint list of tunnelTerminationPoint
     */
    void tunnelTerminationPoint(List<TunnelTerminationPoint> tunnelTerminationPoint);

    /**
     * Adds to the list of tunnelTerminationPoint.
     *
     * @param addTo value of tunnelTerminationPoint
     */
    void addToTunnelTerminationPoint(TunnelTerminationPoint addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}