/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes;

/**
 * Represents the implementation of switchingL2Sc.
 */
public abstract class SwitchingL2Sc extends SwitchingCapabilities {

    /**
     * Returns the attribute switching-l2sc.
     *
     * @return switching-l2sc value of switching-l2sc
     */
    public static String switchingL2ScToString() {
        return "switching-l2sc";
    }

    /**
     * Returns the object of switchingL2Sc fromString input String switchingL2Sc.
     *
     * @param valInString value of input String
     * @return switchingL2Sc
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("switching-l2sc")) {
            return SwitchingL2Sc.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}