/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.explicitroutesubobject.type;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.IpAddress;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.explicitroutesubobject.Type;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of unnumberedLink.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultUnnumberedLink extends InnerModelObject implements UnnumberedLink {
    protected IpAddress routerId;
    protected long interfaceId;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public IpAddress routerId() {
        return routerId;
    }

    @Override
    public long interfaceId() {
        return interfaceId;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void routerId(IpAddress routerId) {
        valueLeafFlags.set(LeafIdentifier.ROUTERID.getLeafIndex());
        this.routerId = routerId;
    }

    @Override
    public void interfaceId(long interfaceId) {
        valueLeafFlags.set(LeafIdentifier.INTERFACEID.getLeafIndex());
        this.interfaceId = interfaceId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(routerId, interfaceId, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultUnnumberedLink) {
            DefaultUnnumberedLink other = (DefaultUnnumberedLink) obj;
            return
                Objects.deepEquals(routerId, other.routerId) &&
                Objects.deepEquals(interfaceId, other.interfaceId) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("routerId=" + routerId)
            .add("interfaceId=" + interfaceId)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultUnnumberedLink.
     */
    public DefaultUnnumberedLink() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}