/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.serializers.xml;

import java.util.List;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.ResourceId;
import org.onosproject.yang.runtime.AnnotatedNodeInfo;
import org.onosproject.yang.runtime.CompositeData;
import org.onosproject.yang.runtime.HelperContext;
import org.onosproject.yang.runtime.SerializerHelper;
import org.onosproject.yang.serializers.utils.SerializersUtil;
import org.onosproject.yang.serializers.xml.XmlListener;
import org.onosproject.yang.serializers.xml.XmlNodeType;

class XmlSerializerListener
implements XmlListener {
    protected static final String COLON = ":";
    private DataNode.Builder dnBuilder;
    private CompositeData.Builder cBuilder;

    XmlSerializerListener() {
    }

    void dnBuilder(DataNode.Builder builder) {
        this.dnBuilder = builder;
    }

    DataNode.Builder dnBuilder() {
        return this.dnBuilder;
    }

    public CompositeData.Builder cBuilder() {
        return this.cBuilder;
    }

    public void cBuilder(CompositeData.Builder cBuilder) {
        this.cBuilder = cBuilder;
    }

    @Override
    public void enterXmlElement(Element element, XmlNodeType nodeType, Element rootElement) {
        if (element.equals(rootElement)) {
            return;
        }
        if (this.dnBuilder != null) {
            if (nodeType == XmlNodeType.OBJECT_NODE) {
                List cont = element.content();
                if (cont != null && cont.size() == 2 && this.isValueNsForLeaf(cont, element)) {
                    return;
                }
                this.dnBuilder = SerializerHelper.addDataNode((DataNode.Builder)this.dnBuilder, (String)element.getName(), (String)element.getNamespace().getURI(), null, null);
            } else if (nodeType == XmlNodeType.TEXT_NODE) {
                this.dnBuilder = SerializerHelper.addDataNode((DataNode.Builder)this.dnBuilder, (String)element.getName(), (String)element.getNamespace().getURI(), (String)element.getText(), null, null);
            }
        }
    }

    private boolean isValueNsForLeaf(List cont, Element element) {
        for (Object c : cont) {
            if (!(c instanceof Namespace)) continue;
            String value = element.getText();
            String valueNs = ((Namespace)c).getURI();
            if (value == null) continue;
            String actVal = SerializersUtil.getLatterSegment((String)value, (String)COLON);
            String valPrefix = SerializersUtil.getPreSegment((String)value, (String)COLON);
            if (valPrefix == null || actVal == null || !valPrefix.equals(((Namespace)c).getPrefix())) continue;
            this.dnBuilder = SerializerHelper.addDataNode((DataNode.Builder)this.dnBuilder, (String)element.getName(), (String)element.getNamespace().getURI(), (String)actVal, (String)valueNs, null);
            return true;
        }
        return false;
    }

    @Override
    public void exitXmlElement(Element element, XmlNodeType nodeType, Element rootElement) {
        HelperContext info;
        if (element.equals(rootElement)) {
            return;
        }
        ResourceId id = SerializerHelper.getResourceId((DataNode.Builder)this.dnBuilder);
        AnnotatedNodeInfo annotatedNodeInfo = SerializersUtil.convertXmlAttributesToAnnotations((Element)element, (ResourceId)id);
        if (annotatedNodeInfo != null) {
            this.cBuilder.addAnnotatedNodeInfo(annotatedNodeInfo);
        }
        if ((info = (HelperContext)this.dnBuilder.appInfo()).getParentResourceIdBldr() == null) {
            this.dnBuilder = SerializerHelper.exitDataNode((DataNode.Builder)this.dnBuilder);
        }
    }
}

