/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfnetwork.rev20151208.yrtietfnetwork.networks;

import org.onosproject.yang.gen.v1.yrtietfnetwork.rev20151208.yrtietfnetwork.NetworkId;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of network.
 */
public class NetworkKeys implements KeyInfo<DefaultNetwork> {
    protected NetworkId networkId;
    /**
     * Returns the attribute networkId.
     *
     * @return networkId value of networkId
     */
    public NetworkId networkId() {
        return networkId;
    }

    /**
     * Sets the value to attribute networkId.
     *
     * @param networkId value of networkId
     */
    public void networkId(NetworkId networkId) {
        this.networkId = networkId;
    }


    @Override
    public int hashCode() {
        return Objects.hash(networkId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NetworkKeys) {
            NetworkKeys other = (NetworkKeys) obj;
            return
                Objects.deepEquals(networkId, other.networkId);
        }
        return false;
    }
}