/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.informationsourceattributes.InformationSourceEnum;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.informationsourceattributes.InformationSourceState;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tenodeconfigattributesnotification.TeNodeAttributes;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tenodestatederivednotification.AltInformationSources;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tetopologytype.TeTopology;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of teNodeEvent.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultTeNodeEvent extends InnerModelObject implements TeNodeEvent {
    protected TeTopologyEventType eventType;
    protected Object nodeRef;
    protected Object networkRef;
    protected TeOperStatus operStatus;
    protected boolean isMultiAccessDr;
    protected InformationSourceEnum informationSource;
    protected BitSet valueLeafFlags = new BitSet();
    protected TeTopology teTopology;
    protected TeNodeAttributes teNodeAttributes;
    protected List<AltInformationSources> altInformationSources;
    protected InformationSourceState informationSourceState;

    @Override
    public TeTopologyEventType eventType() {
        return eventType;
    }

    @Override
    public Object nodeRef() {
        return nodeRef;
    }

    @Override
    public Object networkRef() {
        return networkRef;
    }

    @Override
    public TeOperStatus operStatus() {
        return operStatus;
    }

    @Override
    public boolean isMultiAccessDr() {
        return isMultiAccessDr;
    }

    @Override
    public InformationSourceEnum informationSource() {
        return informationSource;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public TeTopology teTopology() {
        return teTopology;
    }

    @Override
    public TeNodeAttributes teNodeAttributes() {
        return teNodeAttributes;
    }

    @Override
    public List<AltInformationSources> altInformationSources() {
        return altInformationSources;
    }

    @Override
    public InformationSourceState informationSourceState() {
        return informationSourceState;
    }

    @Override
    public void eventType(TeTopologyEventType eventType) {
        valueLeafFlags.set(LeafIdentifier.EVENTTYPE.getLeafIndex());
        this.eventType = eventType;
    }

    @Override
    public void nodeRef(Object nodeRef) {
        valueLeafFlags.set(LeafIdentifier.NODEREF.getLeafIndex());
        this.nodeRef = nodeRef;
    }

    @Override
    public void networkRef(Object networkRef) {
        valueLeafFlags.set(LeafIdentifier.NETWORKREF.getLeafIndex());
        this.networkRef = networkRef;
    }

    @Override
    public void operStatus(TeOperStatus operStatus) {
        valueLeafFlags.set(LeafIdentifier.OPERSTATUS.getLeafIndex());
        this.operStatus = operStatus;
    }

    @Override
    public void isMultiAccessDr(boolean isMultiAccessDr) {
        valueLeafFlags.set(LeafIdentifier.ISMULTIACCESSDR.getLeafIndex());
        this.isMultiAccessDr = isMultiAccessDr;
    }

    @Override
    public void informationSource(InformationSourceEnum informationSource) {
        valueLeafFlags.set(LeafIdentifier.INFORMATIONSOURCE.getLeafIndex());
        this.informationSource = informationSource;
    }

    @Override
    public void teTopology(TeTopology teTopology) {
        this.teTopology = teTopology;
    }

    @Override
    public void teNodeAttributes(TeNodeAttributes teNodeAttributes) {
        this.teNodeAttributes = teNodeAttributes;
    }

    @Override
    public void altInformationSources(List<AltInformationSources> altInformationSources) {
        this.altInformationSources = altInformationSources;
    }

    @Override
    public void informationSourceState(InformationSourceState informationSourceState) {
        this.informationSourceState = informationSourceState;
    }

    @Override
    public void addToAltInformationSources(AltInformationSources addTo) {
        if (altInformationSources == null) {
            altInformationSources = new ArrayList<>();
        }
        altInformationSources.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(eventType, nodeRef, networkRef, operStatus, isMultiAccessDr, informationSource, valueLeafFlags, teTopology, teNodeAttributes, altInformationSources, informationSourceState);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTeNodeEvent) {
            DefaultTeNodeEvent other = (DefaultTeNodeEvent) obj;
            return
                Objects.deepEquals(eventType, other.eventType) &&
                Objects.deepEquals(nodeRef, other.nodeRef) &&
                Objects.deepEquals(networkRef, other.networkRef) &&
                Objects.deepEquals(operStatus, other.operStatus) &&
                Objects.deepEquals(isMultiAccessDr, other.isMultiAccessDr) &&
                Objects.deepEquals(informationSource, other.informationSource) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(teTopology, other.teTopology) &&
                Objects.deepEquals(teNodeAttributes, other.teNodeAttributes) &&
                Objects.deepEquals(altInformationSources, other.altInformationSources) &&
                Objects.deepEquals(informationSourceState, other.informationSourceState);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("eventType=" + eventType)
            .add("nodeRef=" + nodeRef)
            .add("networkRef=" + networkRef)
            .add("operStatus=" + operStatus)
            .add("isMultiAccessDr=" + isMultiAccessDr)
            .add("informationSource=" + informationSource)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("teTopology=" + teTopology)
            .add("teNodeAttributes=" + teNodeAttributes)
            .add("altInformationSources=" + altInformationSources)
            .add("informationSourceState=" + informationSourceState)
            .toString();
    }


    /**
     * Creates an instance of defaultTeNodeEvent.
     */
    public DefaultTeNodeEvent() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}