/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology;

import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.IpAddress;
import java.util.Objects;

/**
 * Represents the implementation of teNodeId.
 */
public final class TeNodeId {

    private IpAddress ipAddress;

    /**
     * Creates an instance of teNodeId.
     */
    private TeNodeId() {
    }

    /**
     * Creates an instance of ipAddress.
     *
     * @param ipAddress value of ipAddress
     */
    public TeNodeId(IpAddress ipAddress) {
        this.ipAddress = ipAddress;
    }

    /**
     * Returns the object of teNodeId for type ipAddress.
     *
     * @param value value of teNodeId for type ipAddress
     * @return teNodeId for type ipAddress
     */
    public static TeNodeId of(IpAddress value) {
        return new TeNodeId(value);
    }

    /**
     * Returns the attribute ipAddress.
     *
     * @return ipAddress value of ipAddress
     */
    public IpAddress ipAddress() {
        return ipAddress;
    }
    /**
     * Sets the attribute ipAddress.
     *
     * @param ipAddress value of ipAddress
     */
    public void ipAddress(IpAddress ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Override
    public int hashCode() {
        return Objects.hash(ipAddress);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TeNodeId) {
            TeNodeId other = (TeNodeId) obj;
            return
                Objects.deepEquals(ipAddress, other.ipAddress);
        }
        return false;
    }

    @Override
    public String toString() {
        return ipAddress.toString();
    }
    /**
     * Returns the object of teNodeId fromString input String teNodeId.
     *
     * @param valInString value of input String
     * @return teNodeId
     */
    public static TeNodeId fromString(String valInString) {
        try {
            IpAddress tmpVal = IpAddress.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
