/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.choicecase.rev20160624.choicecase.snack;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.choicecase.rev20160624.choicecase.Snack;
import org.onosproject.yang.gen.v1.choicecase.rev20160624.choicecase.snack.sportsarena.Bear;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of sportsarena.
 */
public interface Sportsarena extends Snack, Augmentable  {

    /**
     * Identify the leaf of Sportsarena.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents pretzel.
         */
        PRETZEL(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute pretzel.
     *
     * @return pretzel value of pretzel
     */
    boolean pretzel();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute bear.
     *
     * @return bear value of bear
     */
    Bear bear();

    /**
     * Sets the attribute pretzel.
     *
     * @param pretzel value of pretzel
     */
    void pretzel(boolean pretzel);

    /**
     * Sets the attribute bear.
     *
     * @param bear value of bear
     */
    void bear(Bear bear);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}