/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.food.rev20160624.food.food.snack;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.food.rev20160624.food.food.Snack;
import org.onosproject.yang.gen.v1.food.rev20160624.food.food.snack.latenight.ChocolateEnum;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of latenight.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultLatenight extends InnerModelObject implements Latenight {
    protected ChocolateEnum chocolate;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public ChocolateEnum chocolate() {
        return chocolate;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void chocolate(ChocolateEnum chocolate) {
        valueLeafFlags.set(LeafIdentifier.CHOCOLATE.getLeafIndex());
        this.chocolate = chocolate;
    }

    @Override
    public int hashCode() {
        return Objects.hash(chocolate, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultLatenight) {
            DefaultLatenight other = (DefaultLatenight) obj;
            return
                Objects.deepEquals(chocolate, other.chocolate) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("chocolate=" + chocolate)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultLatenight.
     */
    public DefaultLatenight() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}