/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.identitytest.rev20130715.identitytest;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.identitytest.rev20130715.identitytest.test.Con1;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of test.
 */
public interface Test extends Augmentable  {

    /**
     * Identify the leaf of Test.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents l.
         */
        L(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute l.
     *
     * @return l value of l
     */
    String l();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute con1.
     *
     * @return con1 value of con1
     */
    Con1 con1();

    /**
     * Sets the attribute l.
     *
     * @param l value of l
     */
    void l(String l);

    /**
     * Sets the attribute con1.
     *
     * @param con1 value of con1
     */
    void con1(Con1 con1);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}