/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.identitytest.rev20130715.identitytest;

import org.onosproject.yang.gen.v1.identitytest.rev20130715.identitytest.typed.TypedUnion;
import java.util.Objects;

/**
 * Represents the implementation of typed.
 */
public final class Typed {

    private TypedUnion union;

    /**
     * Creates an instance of typed.
     */
    private Typed() {
    }

    /**
     * Creates an instance of union.
     *
     * @param union value of union
     */
    public Typed(TypedUnion union) {
        this.union = union;
    }

    /**
     * Returns the object of typed for type union.
     *
     * @param value value of typed for type union
     * @return typed for type union
     */
    public static Typed of(TypedUnion value) {
        return new Typed(value);
    }

    /**
     * Returns the attribute union.
     *
     * @return union value of union
     */
    public TypedUnion union() {
        return union;
    }
    /**
     * Sets the attribute union.
     *
     * @param union value of union
     */
    public void union(TypedUnion union) {
        this.union = union;
    }

    @Override
    public int hashCode() {
        return Objects.hash(union);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Typed) {
            Typed other = (Typed) obj;
            return
                Objects.deepEquals(union, other.union);
        }
        return false;
    }

    @Override
    public String toString() {
        return union.toString();
    }
    /**
     * Returns the object of typed fromString input String typed.
     *
     * @param valInString value of input String
     * @return typed
     */
    public static Typed fromString(String valInString) {
        try {
            TypedUnion tmpVal = TypedUnion.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
