/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.identitytest.rev20130715.identitytest.test;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.identitytest.rev20130715.identitytest.test.con1.Interfaces;
import org.onosproject.yang.gen.v1.identitytypes.rev20130715.identitytypes.IntType;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of con1.
 */
public interface Con1 extends Augmentable  {

    /**
     * Identify the leaf of Con1.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents yangAutoPrefixInterface.
         */
        YANGAUTOPREFIXINTERFACE(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute yangAutoPrefixInterface.
     *
     * @return yangAutoPrefixInterface value of yangAutoPrefixInterface
     */
    Class<? extends IntType> yangAutoPrefixInterface();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute interfaces.
     *
     * @return interfaces value of interfaces
     */
    Interfaces interfaces();

    /**
     * Sets the attribute yangAutoPrefixInterface.
     *
     * @param yangAutoPrefixInterface value of yangAutoPrefixInterface
     */
    void yangAutoPrefixInterface(Class<? extends IntType> yangAutoPrefixInterface);

    /**
     * Sets the attribute interfaces.
     *
     * @param interfaces value of interfaces
     */
    void interfaces(Interfaces interfaces);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}