/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.identitytest.rev20130715.identitytest.test.con1;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.identitytest.rev20130715.identitytest.test.con1.interfaces.IntList;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of interfaces.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultInterfaces extends InnerModelObject implements Interfaces {
    protected List<IntList> intList;

    @Override
    public List<IntList> intList() {
        return intList;
    }

    @Override
    public void intList(List<IntList> intList) {
        this.intList = intList;
    }

    @Override
    public void addToIntList(IntList addTo) {
        if (intList == null) {
            intList = new ArrayList<>();
        }
        intList.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(intList);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultInterfaces) {
            DefaultInterfaces other = (DefaultInterfaces) obj;
            return
                Objects.deepEquals(intList, other.intList);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("intList=" + intList)
            .toString();
    }


    /**
     * Creates an instance of defaultInterfaces.
     */
    public DefaultInterfaces() {
    }

}