/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.identitytest.rev20130715.identitytest.test.con1.interfaces;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.identitytest.rev20130715.identitytest.Typed;
import org.onosproject.yang.gen.v1.identitytest.rev20130715.identitytest.test.con1.interfaces.intlist.Available;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of intList.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultIntList extends InnerModelObject 
        implements IntList, MultiInstanceObject<IntListKeys> {
    protected Typed iden;
    protected BitSet valueLeafFlags = new BitSet();
    protected Available available;

    @Override
    public Typed iden() {
        return iden;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Available available() {
        return available;
    }

    @Override
    public void iden(Typed iden) {
        valueLeafFlags.set(LeafIdentifier.IDEN.getLeafIndex());
        this.iden = iden;
    }

    @Override
    public void available(Available available) {
        this.available = available;
    }

    @Override
    public int hashCode() {
        return Objects.hash(iden, valueLeafFlags, available);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultIntList) {
            DefaultIntList other = (DefaultIntList) obj;
            return
                Objects.deepEquals(iden, other.iden) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(available, other.available);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("iden=" + iden)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("available=" + available)
            .toString();
    }


    /**
     * Creates an instance of defaultIntList.
     */
    public DefaultIntList() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}