/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.identitytest.rev20130715.identitytest.test.con1.interfaces;

import org.onosproject.yang.gen.v1.identitytest.rev20130715.identitytest.Typed;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of intList.
 */
public class IntListKeys implements KeyInfo<DefaultIntList> {
    protected Typed iden;
    /**
     * Returns the attribute iden.
     *
     * @return iden value of iden
     */
    public Typed iden() {
        return iden;
    }

    /**
     * Sets the value to attribute iden.
     *
     * @param iden value of iden
     */
    public void iden(Typed iden) {
        this.iden = iden;
    }


    @Override
    public int hashCode() {
        return Objects.hash(iden);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IntListKeys) {
            IntListKeys other = (IntListKeys) obj;
            return
                Objects.deepEquals(iden, other.iden);
        }
        return false;
    }
}