/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.identitytypes.rev20130715.identitytypes;

import org.onosproject.yang.gen.v1.identitytest.rev20130715.identitytest.Giga;
import org.onosproject.yang.gen.v1.identitytest.rev20130715.identitytest.Optical;
import org.onosproject.yang.gen.v1.identitytypessecond.rev20130715.identitytypessecond.Ethernet;
import org.onosproject.yang.gen.v1.identitytypessecond.rev20130715.identitytypessecond.Virtual;

/**
 * Represents the implementation of intType.
 */
public abstract class IntType {

    /**
     * Returns the attribute int-type.
     *
     * @return int-type value of int-type
     */
    public static String intTypeToString() {
        return "int-type";
    }

    /**
     * Returns the object of intType fromString input String intType.
     *
     * @param valInString value of input String
     * @return intType
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("int-type")) {
            return IntType.class;
        } else if (valInString.equals("physical")) {
            return Physical.class;
        } else if (valInString.equals("virtual")) {
            return Virtual.class;
        } else if (valInString.equals("optical")) {
            return Optical.class;
        } else if (valInString.equals("Giga")) {
            return Giga.class;
        } else if (valInString.equals("Ethernet")) {
            return Ethernet.class;
        } else if (valInString.equals("Loopback")) {
            return Loopback.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}