/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.identitytypessecond.rev20130715.identitytypessecond;

import org.onosproject.yang.gen.v1.identitytypes.rev20130715.identitytypes.Physical;

/**
 * Represents the implementation of ethernet.
 */
public abstract class Ethernet extends Physical {

    /**
     * Returns the attribute ethernet.
     *
     * @return ethernet value of ethernet
     */
    public static String ethernetToString() {
        return "Ethernet";
    }

    /**
     * Returns the object of ethernet fromString input String ethernet.
     *
     * @param valInString value of input String
     * @return ethernet
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("Ethernet")) {
            return Ethernet.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}