/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfnetwork.rev20151208.yrtietfnetwork;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietfnetwork.rev20151208.yrtietfnetwork.networksstate.Network;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of networksState.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultNetworksState extends InnerModelObject implements NetworksState {
    protected List<Network> network;

    @Override
    public List<Network> network() {
        return network;
    }

    @Override
    public void network(List<Network> network) {
        this.network = network;
    }

    @Override
    public void addToNetwork(Network addTo) {
        if (network == null) {
            network = new ArrayList<>();
        }
        network.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(network);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultNetworksState) {
            DefaultNetworksState other = (DefaultNetworksState) obj;
            return
                Objects.deepEquals(network, other.network);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("network=" + network)
            .toString();
    }


    /**
     * Creates an instance of defaultNetworksState.
     */
    public DefaultNetworksState() {
    }

}