/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfnetwork.rev20151208.yrtietfnetwork.networksstate;

import java.util.BitSet;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of network.
 */
public interface Network extends Augmentable  {

    /**
     * Identify the leaf of Network.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents serverProvided.
         */
        SERVERPROVIDED(1),
        /**
         * Represents networkRef.
         */
        NETWORKREF(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute serverProvided.
     *
     * @return serverProvided value of serverProvided
     */
    boolean serverProvided();

    /**
     * Returns the attribute networkRef.
     *
     * @return networkRef value of networkRef
     */
    Object networkRef();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute serverProvided.
     *
     * @param serverProvided value of serverProvided
     */
    void serverProvided(boolean serverProvided);

    /**
     * Sets the attribute networkRef.
     *
     * @param networkRef value of networkRef
     */
    void networkRef(Object networkRef);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}