/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfschedule.rev20160301.yrtietfschedule.schedules.schedules;

import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of schedule.
 */
public class ScheduleKeys implements KeyInfo<DefaultSchedule> {
    protected long scheduleId;
    /**
     * Returns the attribute scheduleId.
     *
     * @return scheduleId value of scheduleId
     */
    public long scheduleId() {
        return scheduleId;
    }

    /**
     * Sets the value to attribute scheduleId.
     *
     * @param scheduleId value of scheduleId
     */
    public void scheduleId(long scheduleId) {
        this.scheduleId = scheduleId;
    }


    @Override
    public int hashCode() {
        return Objects.hash(scheduleId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ScheduleKeys) {
            ScheduleKeys other = (ScheduleKeys) obj;
            return
                Objects.deepEquals(scheduleId, other.scheduleId);
        }
        return false;
    }
}