/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.performancemetricnormality;

/**
 * Represents ENUM data of performanceMetricNormalityEnum.
 */
public enum PerformanceMetricNormalityEnum {

    /**
     * Represents unknown.
     */
    UNKNOWN(0, "unknown"),

    /**
     * Represents normal.
     */
    NORMAL(1, "normal"),

    /**
     * Represents abnormal.
     */
    ABNORMAL(2, "abnormal");

    private int performanceMetricNormalityEnum;
    private String schemaName;

    /**
     * Creates an instance of performanceMetricNormalityEnum.
     *
     * @param performanceMetricNormalityEnum value of performanceMetricNormalityEnum
     */
     PerformanceMetricNormalityEnum(int performanceMetricNormalityEnum, String schemaName) {
        this.performanceMetricNormalityEnum = performanceMetricNormalityEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of performanceMetricNormalityEnum for.
     *
     * @param value value of performanceMetricNormalityEnum for
     * @return performanceMetricNormalityEnum for
     */
    public static PerformanceMetricNormalityEnum of(int value) {
        switch (value) {
            case 0:
                return PerformanceMetricNormalityEnum.UNKNOWN;
            case 1:
                return PerformanceMetricNormalityEnum.NORMAL;
            case 2:
                return PerformanceMetricNormalityEnum.ABNORMAL;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of performanceMetricNormalityEnum for.
     *
     * @param value value of performanceMetricNormalityEnum for
     * @return performanceMetricNormalityEnum for
     */
    public static PerformanceMetricNormalityEnum of(String value) {
        switch (value) {
            case "unknown":
                return PerformanceMetricNormalityEnum.UNKNOWN;
            case "normal":
                return PerformanceMetricNormalityEnum.NORMAL;
            case "abnormal":
                return PerformanceMetricNormalityEnum.ABNORMAL;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute performanceMetricNormalityEnum.
     *
     * @return performanceMetricNormalityEnum value of performanceMetricNormalityEnum
     */
    public int performanceMetricNormalityEnum() {
        return performanceMetricNormalityEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
