/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.performancemetricthrottlecontainer.performancemetricthrottle;

import java.math.BigDecimal;
import java.util.BitSet;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of thresholdIn.
 */
public interface ThresholdIn extends Augmentable  {

    /**
     * Identify the leaf of ThresholdIn.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents unidirectionalDelay.
         */
        UNIDIRECTIONALDELAY(1),
        /**
         * Represents unidirectionalMinDelay.
         */
        UNIDIRECTIONALMINDELAY(2),
        /**
         * Represents unidirectionalMaxDelay.
         */
        UNIDIRECTIONALMAXDELAY(3),
        /**
         * Represents unidirectionalDelayVariation.
         */
        UNIDIRECTIONALDELAYVARIATION(4),
        /**
         * Represents unidirectionalPacketLoss.
         */
        UNIDIRECTIONALPACKETLOSS(5),
        /**
         * Represents unidirectionalResidualBandwidth.
         */
        UNIDIRECTIONALRESIDUALBANDWIDTH(6),
        /**
         * Represents unidirectionalAvailableBandwidth.
         */
        UNIDIRECTIONALAVAILABLEBANDWIDTH(7),
        /**
         * Represents unidirectionalUtilizedBandwidth.
         */
        UNIDIRECTIONALUTILIZEDBANDWIDTH(8);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute unidirectionalDelay.
     *
     * @return unidirectionalDelay value of unidirectionalDelay
     */
    long unidirectionalDelay();

    /**
     * Returns the attribute unidirectionalMinDelay.
     *
     * @return unidirectionalMinDelay value of unidirectionalMinDelay
     */
    long unidirectionalMinDelay();

    /**
     * Returns the attribute unidirectionalMaxDelay.
     *
     * @return unidirectionalMaxDelay value of unidirectionalMaxDelay
     */
    long unidirectionalMaxDelay();

    /**
     * Returns the attribute unidirectionalDelayVariation.
     *
     * @return unidirectionalDelayVariation value of unidirectionalDelayVariation
     */
    long unidirectionalDelayVariation();

    /**
     * Returns the attribute unidirectionalPacketLoss.
     *
     * @return unidirectionalPacketLoss value of unidirectionalPacketLoss
     */
    BigDecimal unidirectionalPacketLoss();

    /**
     * Returns the attribute unidirectionalResidualBandwidth.
     *
     * @return unidirectionalResidualBandwidth value of unidirectionalResidualBandwidth
     */
    BigDecimal unidirectionalResidualBandwidth();

    /**
     * Returns the attribute unidirectionalAvailableBandwidth.
     *
     * @return unidirectionalAvailableBandwidth value of unidirectionalAvailableBandwidth
     */
    BigDecimal unidirectionalAvailableBandwidth();

    /**
     * Returns the attribute unidirectionalUtilizedBandwidth.
     *
     * @return unidirectionalUtilizedBandwidth value of unidirectionalUtilizedBandwidth
     */
    BigDecimal unidirectionalUtilizedBandwidth();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute unidirectionalDelay.
     *
     * @param unidirectionalDelay value of unidirectionalDelay
     */
    void unidirectionalDelay(long unidirectionalDelay);

    /**
     * Sets the attribute unidirectionalMinDelay.
     *
     * @param unidirectionalMinDelay value of unidirectionalMinDelay
     */
    void unidirectionalMinDelay(long unidirectionalMinDelay);

    /**
     * Sets the attribute unidirectionalMaxDelay.
     *
     * @param unidirectionalMaxDelay value of unidirectionalMaxDelay
     */
    void unidirectionalMaxDelay(long unidirectionalMaxDelay);

    /**
     * Sets the attribute unidirectionalDelayVariation.
     *
     * @param unidirectionalDelayVariation value of unidirectionalDelayVariation
     */
    void unidirectionalDelayVariation(long unidirectionalDelayVariation);

    /**
     * Sets the attribute unidirectionalPacketLoss.
     *
     * @param unidirectionalPacketLoss value of unidirectionalPacketLoss
     */
    void unidirectionalPacketLoss(BigDecimal unidirectionalPacketLoss);

    /**
     * Sets the attribute unidirectionalResidualBandwidth.
     *
     * @param unidirectionalResidualBandwidth value of unidirectionalResidualBandwidth
     */
    void unidirectionalResidualBandwidth(BigDecimal unidirectionalResidualBandwidth);

    /**
     * Sets the attribute unidirectionalAvailableBandwidth.
     *
     * @param unidirectionalAvailableBandwidth value of unidirectionalAvailableBandwidth
     */
    void unidirectionalAvailableBandwidth(BigDecimal unidirectionalAvailableBandwidth);

    /**
     * Sets the attribute unidirectionalUtilizedBandwidth.
     *
     * @param unidirectionalUtilizedBandwidth value of unidirectionalUtilizedBandwidth
     */
    void unidirectionalUtilizedBandwidth(BigDecimal unidirectionalUtilizedBandwidth);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}