/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkaccesstype;

/**
 * Represents ENUM data of teLinkAccessTypeEnum.
 */
public enum TeLinkAccessTypeEnum {

    /**
     * Represents point-to-point.
     */
    POINT_TO_POINT(0, "point-to-point"),

    /**
     * Represents multi-access.
     */
    MULTI_ACCESS(1, "multi-access");

    private int teLinkAccessTypeEnum;
    private String schemaName;

    /**
     * Creates an instance of teLinkAccessTypeEnum.
     *
     * @param teLinkAccessTypeEnum value of teLinkAccessTypeEnum
     */
     TeLinkAccessTypeEnum(int teLinkAccessTypeEnum, String schemaName) {
        this.teLinkAccessTypeEnum = teLinkAccessTypeEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of teLinkAccessTypeEnum for.
     *
     * @param value value of teLinkAccessTypeEnum for
     * @return teLinkAccessTypeEnum for
     */
    public static TeLinkAccessTypeEnum of(int value) {
        switch (value) {
            case 0:
                return TeLinkAccessTypeEnum.POINT_TO_POINT;
            case 1:
                return TeLinkAccessTypeEnum.MULTI_ACCESS;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of teLinkAccessTypeEnum for.
     *
     * @param value value of teLinkAccessTypeEnum for
     * @return teLinkAccessTypeEnum for
     */
    public static TeLinkAccessTypeEnum of(String value) {
        switch (value) {
            case "point-to-point":
                return TeLinkAccessTypeEnum.POINT_TO_POINT;
            case "multi-access":
                return TeLinkAccessTypeEnum.MULTI_ACCESS;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute teLinkAccessTypeEnum.
     *
     * @return teLinkAccessTypeEnum value of teLinkAccessTypeEnum
     */
    public int teLinkAccessTypeEnum() {
        return teLinkAccessTypeEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
