/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkaugment.te;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkconfig.BundleStackLevel;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkconfigattributes.TeLinkAttributes;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of config.
 */
public interface Config extends Augmentable  {

    /**
     * Identify the leaf of Config.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents teLinkTemplate.
         */
        TELINKTEMPLATE(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute teLinkTemplate.
     *
     * @return teLinkTemplate list of teLinkTemplate
     */
    List<Object> teLinkTemplate();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute bundleStackLevel.
     *
     * @return bundleStackLevel value of bundleStackLevel
     */
    BundleStackLevel bundleStackLevel();

    /**
     * Returns the attribute teLinkAttributes.
     *
     * @return teLinkAttributes value of teLinkAttributes
     */
    TeLinkAttributes teLinkAttributes();

    /**
     * Sets the attribute teLinkTemplate.
     *
     * @param teLinkTemplate list of teLinkTemplate
     */
    void teLinkTemplate(List<Object> teLinkTemplate);

    /**
     * Sets the attribute bundleStackLevel.
     *
     * @param bundleStackLevel value of bundleStackLevel
     */
    void bundleStackLevel(BundleStackLevel bundleStackLevel);

    /**
     * Sets the attribute teLinkAttributes.
     *
     * @param teLinkAttributes value of teLinkAttributes
     */
    void teLinkAttributes(TeLinkAttributes teLinkAttributes);

    /**
     * Adds to the list of teLinkTemplate.
     *
     * @param addTo value of teLinkTemplate
     */
    void addToTeLinkTemplate(Object addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}