/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkconfig.bundlestacklevel;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkconfig.BundleStackLevel;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkconfig.bundlestacklevel.bundle.BundledLinks;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of bundle.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultBundle extends InnerModelObject implements Bundle {
    protected BundledLinks bundledLinks;

    @Override
    public BundledLinks bundledLinks() {
        return bundledLinks;
    }

    @Override
    public void bundledLinks(BundledLinks bundledLinks) {
        this.bundledLinks = bundledLinks;
    }

    @Override
    public int hashCode() {
        return Objects.hash(bundledLinks);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultBundle) {
            DefaultBundle other = (DefaultBundle) obj;
            return
                Objects.deepEquals(bundledLinks, other.bundledLinks);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("bundledLinks=" + bundledLinks)
            .toString();
    }


    /**
     * Creates an instance of defaultBundle.
     */
    public DefaultBundle() {
    }

}