/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkconfig.bundlestacklevel.bundle;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkconfig.bundlestacklevel.bundle.bundledlinks.BundledLink;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of bundledLinks.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultBundledLinks extends InnerModelObject implements BundledLinks {
    protected List<BundledLink> bundledLink;

    @Override
    public List<BundledLink> bundledLink() {
        return bundledLink;
    }

    @Override
    public void bundledLink(List<BundledLink> bundledLink) {
        this.bundledLink = bundledLink;
    }

    @Override
    public void addToBundledLink(BundledLink addTo) {
        if (bundledLink == null) {
            bundledLink = new ArrayList<>();
        }
        bundledLink.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(bundledLink);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultBundledLinks) {
            DefaultBundledLinks other = (DefaultBundledLinks) obj;
            return
                Objects.deepEquals(bundledLink, other.bundledLink);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("bundledLink=" + bundledLink)
            .toString();
    }


    /**
     * Creates an instance of defaultBundledLinks.
     */
    public DefaultBundledLinks() {
    }

}