/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkconfig.bundlestacklevel.bundle.bundledlinks;

import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of bundledLink.
 */
public class BundledLinkKeys implements KeyInfo<DefaultBundledLink> {
    protected long sequence;
    /**
     * Returns the attribute sequence.
     *
     * @return sequence value of sequence
     */
    public long sequence() {
        return sequence;
    }

    /**
     * Sets the value to attribute sequence.
     *
     * @param sequence value of sequence
     */
    public void sequence(long sequence) {
        this.sequence = sequence;
    }


    @Override
    public int hashCode() {
        return Objects.hash(sequence);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BundledLinkKeys) {
            BundledLinkKeys other = (BundledLinkKeys) obj;
            return
                Objects.deepEquals(sequence, other.sequence);
        }
        return false;
    }
}