/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkconfigattributes;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.yrtietfschedule.rev20160301.yrtietfschedule.schedules.Schedules;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.TeAdminStatus;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.TeLinkAccessType;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.performancemetricthrottlecontainer.PerformanceMetricThrottle;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkconfigattributes.telinkattributes.Underlay;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkinfoattributes.InterfaceSwitchingCapability;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkinfoattributes.LinkProtectionTypeEnum;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkinfoattributes.PerformanceMetric;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkinfoattributes.TeSrlgs;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkinfoattributes.UnreservedBandwidth;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.AdminGroups;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of teLinkAttributes.
 */
public interface TeLinkAttributes extends Augmentable  {

    /**
     * Identify the leaf of TeLinkAttributes.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents accessType.
         */
        ACCESSTYPE(1),
        /**
         * Represents isAbstract.
         */
        ISABSTRACT(2),
        /**
         * Represents name.
         */
        NAME(3),
        /**
         * Represents adminStatus.
         */
        ADMINSTATUS(4),
        /**
         * Represents linkIndex.
         */
        LINKINDEX(5),
        /**
         * Represents administrativeGroup.
         */
        ADMINISTRATIVEGROUP(6),
        /**
         * Represents maxLinkBandwidth.
         */
        MAXLINKBANDWIDTH(7),
        /**
         * Represents maxResvLinkBandwidth.
         */
        MAXRESVLINKBANDWIDTH(8),
        /**
         * Represents teDefaultMetric.
         */
        TEDEFAULTMETRIC(9),
        /**
         * Represents linkProtectionType.
         */
        LINKPROTECTIONTYPE(10);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute accessType.
     *
     * @return accessType value of accessType
     */
    TeLinkAccessType accessType();

    /**
     * Returns the attribute isAbstract.
     *
     * @return isAbstract value of isAbstract
     */
    boolean isAbstract();

    /**
     * Returns the attribute name.
     *
     * @return name value of name
     */
    String name();

    /**
     * Returns the attribute adminStatus.
     *
     * @return adminStatus value of adminStatus
     */
    TeAdminStatus adminStatus();

    /**
     * Returns the attribute linkIndex.
     *
     * @return linkIndex value of linkIndex
     */
    BigInteger linkIndex();

    /**
     * Returns the attribute administrativeGroup.
     *
     * @return administrativeGroup value of administrativeGroup
     */
    AdminGroups administrativeGroup();

    /**
     * Returns the attribute maxLinkBandwidth.
     *
     * @return maxLinkBandwidth value of maxLinkBandwidth
     */
    BigDecimal maxLinkBandwidth();

    /**
     * Returns the attribute maxResvLinkBandwidth.
     *
     * @return maxResvLinkBandwidth value of maxResvLinkBandwidth
     */
    BigDecimal maxResvLinkBandwidth();

    /**
     * Returns the attribute teDefaultMetric.
     *
     * @return teDefaultMetric value of teDefaultMetric
     */
    long teDefaultMetric();

    /**
     * Returns the attribute linkProtectionType.
     *
     * @return linkProtectionType value of linkProtectionType
     */
    LinkProtectionTypeEnum linkProtectionType();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute underlay.
     *
     * @return underlay value of underlay
     */
    Underlay underlay();

    /**
     * Returns the attribute unreservedBandwidth.
     *
     * @return unreservedBandwidth list of unreservedBandwidth
     */
    List<UnreservedBandwidth> unreservedBandwidth();

    /**
     * Returns the attribute performanceMetric.
     *
     * @return performanceMetric value of performanceMetric
     */
    PerformanceMetric performanceMetric();

    /**
     * Returns the attribute interfaceSwitchingCapability.
     *
     * @return interfaceSwitchingCapability list of interfaceSwitchingCapability
     */
    List<InterfaceSwitchingCapability> interfaceSwitchingCapability();

    /**
     * Returns the attribute teSrlgs.
     *
     * @return teSrlgs value of teSrlgs
     */
    TeSrlgs teSrlgs();

    /**
     * Returns the attribute performanceMetricThrottle.
     *
     * @return performanceMetricThrottle value of performanceMetricThrottle
     */
    PerformanceMetricThrottle performanceMetricThrottle();

    /**
     * Returns the attribute schedules.
     *
     * @return schedules value of schedules
     */
    Schedules schedules();

    /**
     * Sets the attribute accessType.
     *
     * @param accessType value of accessType
     */
    void accessType(TeLinkAccessType accessType);

    /**
     * Sets the attribute isAbstract.
     *
     * @param isAbstract value of isAbstract
     */
    void isAbstract(boolean isAbstract);

    /**
     * Sets the attribute name.
     *
     * @param name value of name
     */
    void name(String name);

    /**
     * Sets the attribute adminStatus.
     *
     * @param adminStatus value of adminStatus
     */
    void adminStatus(TeAdminStatus adminStatus);

    /**
     * Sets the attribute linkIndex.
     *
     * @param linkIndex value of linkIndex
     */
    void linkIndex(BigInteger linkIndex);

    /**
     * Sets the attribute administrativeGroup.
     *
     * @param administrativeGroup value of administrativeGroup
     */
    void administrativeGroup(AdminGroups administrativeGroup);

    /**
     * Sets the attribute maxLinkBandwidth.
     *
     * @param maxLinkBandwidth value of maxLinkBandwidth
     */
    void maxLinkBandwidth(BigDecimal maxLinkBandwidth);

    /**
     * Sets the attribute maxResvLinkBandwidth.
     *
     * @param maxResvLinkBandwidth value of maxResvLinkBandwidth
     */
    void maxResvLinkBandwidth(BigDecimal maxResvLinkBandwidth);

    /**
     * Sets the attribute teDefaultMetric.
     *
     * @param teDefaultMetric value of teDefaultMetric
     */
    void teDefaultMetric(long teDefaultMetric);

    /**
     * Sets the attribute linkProtectionType.
     *
     * @param linkProtectionType value of linkProtectionType
     */
    void linkProtectionType(LinkProtectionTypeEnum linkProtectionType);

    /**
     * Sets the attribute underlay.
     *
     * @param underlay value of underlay
     */
    void underlay(Underlay underlay);

    /**
     * Sets the attribute unreservedBandwidth.
     *
     * @param unreservedBandwidth list of unreservedBandwidth
     */
    void unreservedBandwidth(List<UnreservedBandwidth> unreservedBandwidth);

    /**
     * Sets the attribute performanceMetric.
     *
     * @param performanceMetric value of performanceMetric
     */
    void performanceMetric(PerformanceMetric performanceMetric);

    /**
     * Sets the attribute interfaceSwitchingCapability.
     *
     * @param interfaceSwitchingCapability list of interfaceSwitchingCapability
     */
    void interfaceSwitchingCapability(List<InterfaceSwitchingCapability> interfaceSwitchingCapability);

    /**
     * Sets the attribute teSrlgs.
     *
     * @param teSrlgs value of teSrlgs
     */
    void teSrlgs(TeSrlgs teSrlgs);

    /**
     * Sets the attribute performanceMetricThrottle.
     *
     * @param performanceMetricThrottle value of performanceMetricThrottle
     */
    void performanceMetricThrottle(PerformanceMetricThrottle performanceMetricThrottle);

    /**
     * Sets the attribute schedules.
     *
     * @param schedules value of schedules
     */
    void schedules(Schedules schedules);

    /**
     * Adds to the list of unreservedBandwidth.
     *
     * @param addTo value of unreservedBandwidth
     */
    void addToUnreservedBandwidth(UnreservedBandwidth addTo);

    /**
     * Adds to the list of interfaceSwitchingCapability.
     *
     * @param addTo value of interfaceSwitchingCapability
     */
    void addToInterfaceSwitchingCapability(InterfaceSwitchingCapability addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}