/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkinfoattributes.interfaceswitchingcapability;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkinfoattributes.interfaceswitchingcapability.interfaceadjustmentcapability.MaxLspBandwidth;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.LspEncodingTypes;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.SwitchingCapabilities;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of interfaceAdjustmentCapability.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultInterfaceAdjustmentCapability extends InnerModelObject 
        implements InterfaceAdjustmentCapability, MultiInstanceObject<InterfaceAdjustmentCapabilityKeys> {
    protected Class<? extends SwitchingCapabilities> upperSc;
    protected Class<? extends LspEncodingTypes> upperEncoding;
    protected BitSet valueLeafFlags = new BitSet();
    protected List<MaxLspBandwidth> maxLspBandwidth;

    @Override
    public Class<? extends SwitchingCapabilities> upperSc() {
        return upperSc;
    }

    @Override
    public Class<? extends LspEncodingTypes> upperEncoding() {
        return upperEncoding;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public List<MaxLspBandwidth> maxLspBandwidth() {
        return maxLspBandwidth;
    }

    @Override
    public void upperSc(Class<? extends SwitchingCapabilities> upperSc) {
        valueLeafFlags.set(LeafIdentifier.UPPERSC.getLeafIndex());
        this.upperSc = upperSc;
    }

    @Override
    public void upperEncoding(Class<? extends LspEncodingTypes> upperEncoding) {
        valueLeafFlags.set(LeafIdentifier.UPPERENCODING.getLeafIndex());
        this.upperEncoding = upperEncoding;
    }

    @Override
    public void maxLspBandwidth(List<MaxLspBandwidth> maxLspBandwidth) {
        this.maxLspBandwidth = maxLspBandwidth;
    }

    @Override
    public void addToMaxLspBandwidth(MaxLspBandwidth addTo) {
        if (maxLspBandwidth == null) {
            maxLspBandwidth = new ArrayList<>();
        }
        maxLspBandwidth.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(upperSc, upperEncoding, valueLeafFlags, maxLspBandwidth);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultInterfaceAdjustmentCapability) {
            DefaultInterfaceAdjustmentCapability other = (DefaultInterfaceAdjustmentCapability) obj;
            return
                Objects.deepEquals(upperSc, other.upperSc) &&
                Objects.deepEquals(upperEncoding, other.upperEncoding) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(maxLspBandwidth, other.maxLspBandwidth);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("upperSc=" + upperSc)
            .add("upperEncoding=" + upperEncoding)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("maxLspBandwidth=" + maxLspBandwidth)
            .toString();
    }


    /**
     * Creates an instance of defaultInterfaceAdjustmentCapability.
     */
    public DefaultInterfaceAdjustmentCapability() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}