/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkinfoattributes.interfaceswitchingcapability;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkinfoattributes.interfaceswitchingcapability.interfaceadjustmentcapability.MaxLspBandwidth;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.LspEncodingTypes;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.SwitchingCapabilities;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of interfaceAdjustmentCapability.
 */
public interface InterfaceAdjustmentCapability extends Augmentable  {

    /**
     * Identify the leaf of InterfaceAdjustmentCapability.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents upperSc.
         */
        UPPERSC(1),
        /**
         * Represents upperEncoding.
         */
        UPPERENCODING(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute upperSc.
     *
     * @return upperSc value of upperSc
     */
    Class<? extends SwitchingCapabilities> upperSc();

    /**
     * Returns the attribute upperEncoding.
     *
     * @return upperEncoding value of upperEncoding
     */
    Class<? extends LspEncodingTypes> upperEncoding();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute maxLspBandwidth.
     *
     * @return maxLspBandwidth list of maxLspBandwidth
     */
    List<MaxLspBandwidth> maxLspBandwidth();

    /**
     * Sets the attribute upperSc.
     *
     * @param upperSc value of upperSc
     */
    void upperSc(Class<? extends SwitchingCapabilities> upperSc);

    /**
     * Sets the attribute upperEncoding.
     *
     * @param upperEncoding value of upperEncoding
     */
    void upperEncoding(Class<? extends LspEncodingTypes> upperEncoding);

    /**
     * Sets the attribute maxLspBandwidth.
     *
     * @param maxLspBandwidth list of maxLspBandwidth
     */
    void maxLspBandwidth(List<MaxLspBandwidth> maxLspBandwidth);

    /**
     * Adds to the list of maxLspBandwidth.
     *
     * @param addTo value of maxLspBandwidth
     */
    void addToMaxLspBandwidth(MaxLspBandwidth addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}