/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkstatederived;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.informationsourceattributes.InformationSourceEnum;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.informationsourceattributes.InformationSourceState;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkinfoattributes.InterfaceSwitchingCapability;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkinfoattributes.LinkProtectionTypeEnum;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkinfoattributes.PerformanceMetric;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkinfoattributes.TeSrlgs;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkinfoattributes.UnreservedBandwidth;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.AdminGroups;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of altInformationSources.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultAltInformationSources extends InnerModelObject 
        implements AltInformationSources, MultiInstanceObject<AltInformationSourcesKeys> {
    protected BigInteger linkIndex;
    protected AdminGroups administrativeGroup;
    protected BigDecimal maxLinkBandwidth;
    protected BigDecimal maxResvLinkBandwidth;
    protected long teDefaultMetric;
    protected LinkProtectionTypeEnum linkProtectionType;
    protected InformationSourceEnum informationSource;
    protected BitSet valueLeafFlags = new BitSet();
    protected List<UnreservedBandwidth> unreservedBandwidth;
    protected PerformanceMetric performanceMetric;
    protected List<InterfaceSwitchingCapability> interfaceSwitchingCapability;
    protected TeSrlgs teSrlgs;
    protected InformationSourceState informationSourceState;

    @Override
    public BigInteger linkIndex() {
        return linkIndex;
    }

    @Override
    public AdminGroups administrativeGroup() {
        return administrativeGroup;
    }

    @Override
    public BigDecimal maxLinkBandwidth() {
        return maxLinkBandwidth;
    }

    @Override
    public BigDecimal maxResvLinkBandwidth() {
        return maxResvLinkBandwidth;
    }

    @Override
    public long teDefaultMetric() {
        return teDefaultMetric;
    }

    @Override
    public LinkProtectionTypeEnum linkProtectionType() {
        return linkProtectionType;
    }

    @Override
    public InformationSourceEnum informationSource() {
        return informationSource;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public List<UnreservedBandwidth> unreservedBandwidth() {
        return unreservedBandwidth;
    }

    @Override
    public PerformanceMetric performanceMetric() {
        return performanceMetric;
    }

    @Override
    public List<InterfaceSwitchingCapability> interfaceSwitchingCapability() {
        return interfaceSwitchingCapability;
    }

    @Override
    public TeSrlgs teSrlgs() {
        return teSrlgs;
    }

    @Override
    public InformationSourceState informationSourceState() {
        return informationSourceState;
    }

    @Override
    public void linkIndex(BigInteger linkIndex) {
        valueLeafFlags.set(LeafIdentifier.LINKINDEX.getLeafIndex());
        this.linkIndex = linkIndex;
    }

    @Override
    public void administrativeGroup(AdminGroups administrativeGroup) {
        valueLeafFlags.set(LeafIdentifier.ADMINISTRATIVEGROUP.getLeafIndex());
        this.administrativeGroup = administrativeGroup;
    }

    @Override
    public void maxLinkBandwidth(BigDecimal maxLinkBandwidth) {
        valueLeafFlags.set(LeafIdentifier.MAXLINKBANDWIDTH.getLeafIndex());
        this.maxLinkBandwidth = maxLinkBandwidth;
    }

    @Override
    public void maxResvLinkBandwidth(BigDecimal maxResvLinkBandwidth) {
        valueLeafFlags.set(LeafIdentifier.MAXRESVLINKBANDWIDTH.getLeafIndex());
        this.maxResvLinkBandwidth = maxResvLinkBandwidth;
    }

    @Override
    public void teDefaultMetric(long teDefaultMetric) {
        valueLeafFlags.set(LeafIdentifier.TEDEFAULTMETRIC.getLeafIndex());
        this.teDefaultMetric = teDefaultMetric;
    }

    @Override
    public void linkProtectionType(LinkProtectionTypeEnum linkProtectionType) {
        valueLeafFlags.set(LeafIdentifier.LINKPROTECTIONTYPE.getLeafIndex());
        this.linkProtectionType = linkProtectionType;
    }

    @Override
    public void informationSource(InformationSourceEnum informationSource) {
        valueLeafFlags.set(LeafIdentifier.INFORMATIONSOURCE.getLeafIndex());
        this.informationSource = informationSource;
    }

    @Override
    public void unreservedBandwidth(List<UnreservedBandwidth> unreservedBandwidth) {
        this.unreservedBandwidth = unreservedBandwidth;
    }

    @Override
    public void performanceMetric(PerformanceMetric performanceMetric) {
        this.performanceMetric = performanceMetric;
    }

    @Override
    public void interfaceSwitchingCapability(List<InterfaceSwitchingCapability> interfaceSwitchingCapability) {
        this.interfaceSwitchingCapability = interfaceSwitchingCapability;
    }

    @Override
    public void teSrlgs(TeSrlgs teSrlgs) {
        this.teSrlgs = teSrlgs;
    }

    @Override
    public void informationSourceState(InformationSourceState informationSourceState) {
        this.informationSourceState = informationSourceState;
    }

    @Override
    public void addToUnreservedBandwidth(UnreservedBandwidth addTo) {
        if (unreservedBandwidth == null) {
            unreservedBandwidth = new ArrayList<>();
        }
        unreservedBandwidth.add(addTo);
    }


    @Override
    public void addToInterfaceSwitchingCapability(InterfaceSwitchingCapability addTo) {
        if (interfaceSwitchingCapability == null) {
            interfaceSwitchingCapability = new ArrayList<>();
        }
        interfaceSwitchingCapability.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(linkIndex, administrativeGroup, maxLinkBandwidth, maxResvLinkBandwidth, teDefaultMetric, linkProtectionType, informationSource, valueLeafFlags, unreservedBandwidth, performanceMetric, interfaceSwitchingCapability, teSrlgs, informationSourceState);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAltInformationSources) {
            DefaultAltInformationSources other = (DefaultAltInformationSources) obj;
            return
                Objects.deepEquals(linkIndex, other.linkIndex) &&
                Objects.deepEquals(administrativeGroup, other.administrativeGroup) &&
                Objects.deepEquals(maxLinkBandwidth, other.maxLinkBandwidth) &&
                Objects.deepEquals(maxResvLinkBandwidth, other.maxResvLinkBandwidth) &&
                Objects.deepEquals(teDefaultMetric, other.teDefaultMetric) &&
                Objects.deepEquals(linkProtectionType, other.linkProtectionType) &&
                Objects.deepEquals(informationSource, other.informationSource) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(unreservedBandwidth, other.unreservedBandwidth) &&
                Objects.deepEquals(performanceMetric, other.performanceMetric) &&
                Objects.deepEquals(interfaceSwitchingCapability, other.interfaceSwitchingCapability) &&
                Objects.deepEquals(teSrlgs, other.teSrlgs) &&
                Objects.deepEquals(informationSourceState, other.informationSourceState);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("linkIndex=" + linkIndex)
            .add("administrativeGroup=" + administrativeGroup)
            .add("maxLinkBandwidth=" + maxLinkBandwidth)
            .add("maxResvLinkBandwidth=" + maxResvLinkBandwidth)
            .add("teDefaultMetric=" + teDefaultMetric)
            .add("linkProtectionType=" + linkProtectionType)
            .add("informationSource=" + informationSource)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("unreservedBandwidth=" + unreservedBandwidth)
            .add("performanceMetric=" + performanceMetric)
            .add("interfaceSwitchingCapability=" + interfaceSwitchingCapability)
            .add("teSrlgs=" + teSrlgs)
            .add("informationSourceState=" + informationSourceState)
            .toString();
    }


    /**
     * Creates an instance of defaultAltInformationSources.
     */
    public DefaultAltInformationSources() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}