/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkunderlayattributes;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkunderlayattributes.underlaybackuppath.PathElement;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of underlayBackupPath.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultUnderlayBackupPath extends InnerModelObject 
        implements UnderlayBackupPath, MultiInstanceObject<UnderlayBackupPathKeys> {
    protected long index;
    protected Object providerIdRef;
    protected Object clientIdRef;
    protected Object teTopologyIdRef;
    protected Object networkIdRef;
    protected BitSet valueLeafFlags = new BitSet();
    protected List<PathElement> pathElement;

    @Override
    public long index() {
        return index;
    }

    @Override
    public Object providerIdRef() {
        return providerIdRef;
    }

    @Override
    public Object clientIdRef() {
        return clientIdRef;
    }

    @Override
    public Object teTopologyIdRef() {
        return teTopologyIdRef;
    }

    @Override
    public Object networkIdRef() {
        return networkIdRef;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public List<PathElement> pathElement() {
        return pathElement;
    }

    @Override
    public void index(long index) {
        valueLeafFlags.set(LeafIdentifier.INDEX.getLeafIndex());
        this.index = index;
    }

    @Override
    public void providerIdRef(Object providerIdRef) {
        valueLeafFlags.set(LeafIdentifier.PROVIDERIDREF.getLeafIndex());
        this.providerIdRef = providerIdRef;
    }

    @Override
    public void clientIdRef(Object clientIdRef) {
        valueLeafFlags.set(LeafIdentifier.CLIENTIDREF.getLeafIndex());
        this.clientIdRef = clientIdRef;
    }

    @Override
    public void teTopologyIdRef(Object teTopologyIdRef) {
        valueLeafFlags.set(LeafIdentifier.TETOPOLOGYIDREF.getLeafIndex());
        this.teTopologyIdRef = teTopologyIdRef;
    }

    @Override
    public void networkIdRef(Object networkIdRef) {
        valueLeafFlags.set(LeafIdentifier.NETWORKIDREF.getLeafIndex());
        this.networkIdRef = networkIdRef;
    }

    @Override
    public void pathElement(List<PathElement> pathElement) {
        this.pathElement = pathElement;
    }

    @Override
    public void addToPathElement(PathElement addTo) {
        if (pathElement == null) {
            pathElement = new ArrayList<>();
        }
        pathElement.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(index, providerIdRef, clientIdRef, teTopologyIdRef, networkIdRef, valueLeafFlags, pathElement);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultUnderlayBackupPath) {
            DefaultUnderlayBackupPath other = (DefaultUnderlayBackupPath) obj;
            return
                Objects.deepEquals(index, other.index) &&
                Objects.deepEquals(providerIdRef, other.providerIdRef) &&
                Objects.deepEquals(clientIdRef, other.clientIdRef) &&
                Objects.deepEquals(teTopologyIdRef, other.teTopologyIdRef) &&
                Objects.deepEquals(networkIdRef, other.networkIdRef) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(pathElement, other.pathElement);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("index=" + index)
            .add("providerIdRef=" + providerIdRef)
            .add("clientIdRef=" + clientIdRef)
            .add("teTopologyIdRef=" + teTopologyIdRef)
            .add("networkIdRef=" + networkIdRef)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("pathElement=" + pathElement)
            .toString();
    }


    /**
     * Creates an instance of defaultUnderlayBackupPath.
     */
    public DefaultUnderlayBackupPath() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}