/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tenodeaugment.te;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tenodeconfigattributes.TeNodeAttributes;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of config.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultConfig extends InnerModelObject implements Config {
    protected List<Object> teNodeTemplate;
    protected BitSet valueLeafFlags = new BitSet();
    protected TeNodeAttributes teNodeAttributes;

    @Override
    public List<Object> teNodeTemplate() {
        return teNodeTemplate;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public TeNodeAttributes teNodeAttributes() {
        return teNodeAttributes;
    }

    @Override
    public void teNodeTemplate(List<Object> teNodeTemplate) {
        valueLeafFlags.set(LeafIdentifier.TENODETEMPLATE.getLeafIndex());
        this.teNodeTemplate = teNodeTemplate;
    }

    @Override
    public void teNodeAttributes(TeNodeAttributes teNodeAttributes) {
        this.teNodeAttributes = teNodeAttributes;
    }

    @Override
    public void addToTeNodeTemplate(Object addTo) {
        if (teNodeTemplate == null) {
            teNodeTemplate = new ArrayList<>();
        }
        teNodeTemplate.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(teNodeTemplate, valueLeafFlags, teNodeAttributes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultConfig) {
            DefaultConfig other = (DefaultConfig) obj;
            return
                Objects.deepEquals(teNodeTemplate, other.teNodeTemplate) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(teNodeAttributes, other.teNodeAttributes);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("teNodeTemplate=" + teNodeTemplate)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("teNodeAttributes=" + teNodeAttributes)
            .toString();
    }


    /**
     * Creates an instance of defaultConfig.
     */
    public DefaultConfig() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}