/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tenodeaugment.te.tunnelterminationpoint;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tenodetunnelterminationcapability.TerminationCapability;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.LspEncodingTypes;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.SwitchingCapabilities;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of state.
 */
public interface State extends Augmentable  {

    /**
     * Identify the leaf of State.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents switchingCapability.
         */
        SWITCHINGCAPABILITY(1),
        /**
         * Represents encoding.
         */
        ENCODING(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute switchingCapability.
     *
     * @return switchingCapability value of switchingCapability
     */
    Class<? extends SwitchingCapabilities> switchingCapability();

    /**
     * Returns the attribute encoding.
     *
     * @return encoding value of encoding
     */
    Class<? extends LspEncodingTypes> encoding();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute terminationCapability.
     *
     * @return terminationCapability list of terminationCapability
     */
    List<TerminationCapability> terminationCapability();

    /**
     * Sets the attribute switchingCapability.
     *
     * @param switchingCapability value of switchingCapability
     */
    void switchingCapability(Class<? extends SwitchingCapabilities> switchingCapability);

    /**
     * Sets the attribute encoding.
     *
     * @param encoding value of encoding
     */
    void encoding(Class<? extends LspEncodingTypes> encoding);

    /**
     * Sets the attribute terminationCapability.
     *
     * @param terminationCapability list of terminationCapability
     */
    void terminationCapability(List<TerminationCapability> terminationCapability);

    /**
     * Adds to the list of terminationCapability.
     *
     * @param addTo value of terminationCapability
     */
    void addToTerminationCapability(TerminationCapability addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}