/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tenodeconfigattributes;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.DomainName;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.IpAddress;
import org.onosproject.yang.gen.v1.yrtietfschedule.rev20160301.yrtietfschedule.schedules.Schedules;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.TeAdminStatus;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tenodeconnectivitymatrix.ConnectivityMatrix;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tenodeinfoattributes.UnderlayTopology;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of teNodeAttributes.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultTeNodeAttributes extends InnerModelObject implements TeNodeAttributes {
    protected TeAdminStatus adminStatus;
    protected long domainId;
    protected boolean isAbstract;
    protected DomainName name;
    protected List<IpAddress> signalingAddress;
    protected BitSet valueLeafFlags = new BitSet();
    protected UnderlayTopology underlayTopology;
    protected List<ConnectivityMatrix> connectivityMatrix;
    protected Schedules schedules;

    @Override
    public TeAdminStatus adminStatus() {
        return adminStatus;
    }

    @Override
    public long domainId() {
        return domainId;
    }

    @Override
    public boolean isAbstract() {
        return isAbstract;
    }

    @Override
    public DomainName name() {
        return name;
    }

    @Override
    public List<IpAddress> signalingAddress() {
        return signalingAddress;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public UnderlayTopology underlayTopology() {
        return underlayTopology;
    }

    @Override
    public List<ConnectivityMatrix> connectivityMatrix() {
        return connectivityMatrix;
    }

    @Override
    public Schedules schedules() {
        return schedules;
    }

    @Override
    public void adminStatus(TeAdminStatus adminStatus) {
        valueLeafFlags.set(LeafIdentifier.ADMINSTATUS.getLeafIndex());
        this.adminStatus = adminStatus;
    }

    @Override
    public void domainId(long domainId) {
        valueLeafFlags.set(LeafIdentifier.DOMAINID.getLeafIndex());
        this.domainId = domainId;
    }

    @Override
    public void isAbstract(boolean isAbstract) {
        valueLeafFlags.set(LeafIdentifier.ISABSTRACT.getLeafIndex());
        this.isAbstract = isAbstract;
    }

    @Override
    public void name(DomainName name) {
        valueLeafFlags.set(LeafIdentifier.NAME.getLeafIndex());
        this.name = name;
    }

    @Override
    public void signalingAddress(List<IpAddress> signalingAddress) {
        valueLeafFlags.set(LeafIdentifier.SIGNALINGADDRESS.getLeafIndex());
        this.signalingAddress = signalingAddress;
    }

    @Override
    public void underlayTopology(UnderlayTopology underlayTopology) {
        this.underlayTopology = underlayTopology;
    }

    @Override
    public void connectivityMatrix(List<ConnectivityMatrix> connectivityMatrix) {
        this.connectivityMatrix = connectivityMatrix;
    }

    @Override
    public void schedules(Schedules schedules) {
        this.schedules = schedules;
    }

    @Override
    public void addToSignalingAddress(IpAddress addTo) {
        if (signalingAddress == null) {
            signalingAddress = new ArrayList<>();
        }
        signalingAddress.add(addTo);
    }


    @Override
    public void addToConnectivityMatrix(ConnectivityMatrix addTo) {
        if (connectivityMatrix == null) {
            connectivityMatrix = new ArrayList<>();
        }
        connectivityMatrix.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(adminStatus, domainId, isAbstract, name, signalingAddress, valueLeafFlags, underlayTopology, connectivityMatrix, schedules);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTeNodeAttributes) {
            DefaultTeNodeAttributes other = (DefaultTeNodeAttributes) obj;
            return
                Objects.deepEquals(adminStatus, other.adminStatus) &&
                Objects.deepEquals(domainId, other.domainId) &&
                Objects.deepEquals(isAbstract, other.isAbstract) &&
                Objects.deepEquals(name, other.name) &&
                Objects.deepEquals(signalingAddress, other.signalingAddress) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(underlayTopology, other.underlayTopology) &&
                Objects.deepEquals(connectivityMatrix, other.connectivityMatrix) &&
                Objects.deepEquals(schedules, other.schedules);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("adminStatus=" + adminStatus)
            .add("domainId=" + domainId)
            .add("isAbstract=" + isAbstract)
            .add("name=" + name)
            .add("signalingAddress=" + signalingAddress)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("underlayTopology=" + underlayTopology)
            .add("connectivityMatrix=" + connectivityMatrix)
            .add("schedules=" + schedules)
            .toString();
    }


    /**
     * Creates an instance of defaultTeNodeAttributes.
     */
    public DefaultTeNodeAttributes() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}