/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tenodeconfigattributestemplate;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.DomainName;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.IpAddress;
import org.onosproject.yang.gen.v1.yrtietfschedule.rev20160301.yrtietfschedule.schedules.Schedules;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.TeAdminStatus;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tenodeinfoattributes.UnderlayTopology;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of teNodeAttributes.
 */
public interface TeNodeAttributes extends Augmentable  {

    /**
     * Identify the leaf of TeNodeAttributes.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents adminStatus.
         */
        ADMINSTATUS(1),
        /**
         * Represents domainId.
         */
        DOMAINID(2),
        /**
         * Represents isAbstract.
         */
        ISABSTRACT(3),
        /**
         * Represents name.
         */
        NAME(4),
        /**
         * Represents signalingAddress.
         */
        SIGNALINGADDRESS(5);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute adminStatus.
     *
     * @return adminStatus value of adminStatus
     */
    TeAdminStatus adminStatus();

    /**
     * Returns the attribute domainId.
     *
     * @return domainId value of domainId
     */
    long domainId();

    /**
     * Returns the attribute isAbstract.
     *
     * @return isAbstract value of isAbstract
     */
    boolean isAbstract();

    /**
     * Returns the attribute name.
     *
     * @return name value of name
     */
    DomainName name();

    /**
     * Returns the attribute signalingAddress.
     *
     * @return signalingAddress list of signalingAddress
     */
    List<IpAddress> signalingAddress();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute underlayTopology.
     *
     * @return underlayTopology value of underlayTopology
     */
    UnderlayTopology underlayTopology();

    /**
     * Returns the attribute schedules.
     *
     * @return schedules value of schedules
     */
    Schedules schedules();

    /**
     * Sets the attribute adminStatus.
     *
     * @param adminStatus value of adminStatus
     */
    void adminStatus(TeAdminStatus adminStatus);

    /**
     * Sets the attribute domainId.
     *
     * @param domainId value of domainId
     */
    void domainId(long domainId);

    /**
     * Sets the attribute isAbstract.
     *
     * @param isAbstract value of isAbstract
     */
    void isAbstract(boolean isAbstract);

    /**
     * Sets the attribute name.
     *
     * @param name value of name
     */
    void name(DomainName name);

    /**
     * Sets the attribute signalingAddress.
     *
     * @param signalingAddress list of signalingAddress
     */
    void signalingAddress(List<IpAddress> signalingAddress);

    /**
     * Sets the attribute underlayTopology.
     *
     * @param underlayTopology value of underlayTopology
     */
    void underlayTopology(UnderlayTopology underlayTopology);

    /**
     * Sets the attribute schedules.
     *
     * @param schedules value of schedules
     */
    void schedules(Schedules schedules);

    /**
     * Adds to the list of signalingAddress.
     *
     * @param addTo value of signalingAddress
     */
    void addToSignalingAddress(IpAddress addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}