/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tenodestatederivednotification;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.DomainName;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.IpAddress;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.informationsourceattributes.InformationSourceEnum;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.informationsourceattributes.InformationSourceState;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tenodeconnectivitymatrixabs.ConnectivityMatrix;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tenodeinfoattributes.UnderlayTopology;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of altInformationSources.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultAltInformationSources extends InnerModelObject 
        implements AltInformationSources, MultiInstanceObject<AltInformationSourcesKeys> {
    protected InformationSourceEnum informationSource;
    protected long domainId;
    protected boolean isAbstract;
    protected DomainName name;
    protected List<IpAddress> signalingAddress;
    protected BitSet valueLeafFlags = new BitSet();
    protected InformationSourceState informationSourceState;
    protected UnderlayTopology underlayTopology;
    protected List<ConnectivityMatrix> connectivityMatrix;

    @Override
    public InformationSourceEnum informationSource() {
        return informationSource;
    }

    @Override
    public long domainId() {
        return domainId;
    }

    @Override
    public boolean isAbstract() {
        return isAbstract;
    }

    @Override
    public DomainName name() {
        return name;
    }

    @Override
    public List<IpAddress> signalingAddress() {
        return signalingAddress;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public InformationSourceState informationSourceState() {
        return informationSourceState;
    }

    @Override
    public UnderlayTopology underlayTopology() {
        return underlayTopology;
    }

    @Override
    public List<ConnectivityMatrix> connectivityMatrix() {
        return connectivityMatrix;
    }

    @Override
    public void informationSource(InformationSourceEnum informationSource) {
        valueLeafFlags.set(LeafIdentifier.INFORMATIONSOURCE.getLeafIndex());
        this.informationSource = informationSource;
    }

    @Override
    public void domainId(long domainId) {
        valueLeafFlags.set(LeafIdentifier.DOMAINID.getLeafIndex());
        this.domainId = domainId;
    }

    @Override
    public void isAbstract(boolean isAbstract) {
        valueLeafFlags.set(LeafIdentifier.ISABSTRACT.getLeafIndex());
        this.isAbstract = isAbstract;
    }

    @Override
    public void name(DomainName name) {
        valueLeafFlags.set(LeafIdentifier.NAME.getLeafIndex());
        this.name = name;
    }

    @Override
    public void signalingAddress(List<IpAddress> signalingAddress) {
        valueLeafFlags.set(LeafIdentifier.SIGNALINGADDRESS.getLeafIndex());
        this.signalingAddress = signalingAddress;
    }

    @Override
    public void informationSourceState(InformationSourceState informationSourceState) {
        this.informationSourceState = informationSourceState;
    }

    @Override
    public void underlayTopology(UnderlayTopology underlayTopology) {
        this.underlayTopology = underlayTopology;
    }

    @Override
    public void connectivityMatrix(List<ConnectivityMatrix> connectivityMatrix) {
        this.connectivityMatrix = connectivityMatrix;
    }

    @Override
    public void addToSignalingAddress(IpAddress addTo) {
        if (signalingAddress == null) {
            signalingAddress = new ArrayList<>();
        }
        signalingAddress.add(addTo);
    }


    @Override
    public void addToConnectivityMatrix(ConnectivityMatrix addTo) {
        if (connectivityMatrix == null) {
            connectivityMatrix = new ArrayList<>();
        }
        connectivityMatrix.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(informationSource, domainId, isAbstract, name, signalingAddress, valueLeafFlags, informationSourceState, underlayTopology, connectivityMatrix);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAltInformationSources) {
            DefaultAltInformationSources other = (DefaultAltInformationSources) obj;
            return
                Objects.deepEquals(informationSource, other.informationSource) &&
                Objects.deepEquals(domainId, other.domainId) &&
                Objects.deepEquals(isAbstract, other.isAbstract) &&
                Objects.deepEquals(name, other.name) &&
                Objects.deepEquals(signalingAddress, other.signalingAddress) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(informationSourceState, other.informationSourceState) &&
                Objects.deepEquals(underlayTopology, other.underlayTopology) &&
                Objects.deepEquals(connectivityMatrix, other.connectivityMatrix);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("informationSource=" + informationSource)
            .add("domainId=" + domainId)
            .add("isAbstract=" + isAbstract)
            .add("name=" + name)
            .add("signalingAddress=" + signalingAddress)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("informationSourceState=" + informationSourceState)
            .add("underlayTopology=" + underlayTopology)
            .add("connectivityMatrix=" + connectivityMatrix)
            .toString();
    }


    /**
     * Creates an instance of defaultAltInformationSources.
     */
    public DefaultAltInformationSources() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}