/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tetopologyaugment;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.TeGlobalId;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.TeTopologyId;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tetopologyaugment.te.Config;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tetopologyaugment.te.State;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of te.
 */
public interface Te extends Augmentable  {

    /**
     * Identify the leaf of Te.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents providerId.
         */
        PROVIDERID(1),
        /**
         * Represents clientId.
         */
        CLIENTID(2),
        /**
         * Represents teTopologyId.
         */
        TETOPOLOGYID(3);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute providerId.
     *
     * @return providerId value of providerId
     */
    TeGlobalId providerId();

    /**
     * Returns the attribute clientId.
     *
     * @return clientId value of clientId
     */
    TeGlobalId clientId();

    /**
     * Returns the attribute teTopologyId.
     *
     * @return teTopologyId value of teTopologyId
     */
    TeTopologyId teTopologyId();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute config.
     *
     * @return config value of config
     */
    Config config();

    /**
     * Returns the attribute state.
     *
     * @return state value of state
     */
    State state();

    /**
     * Sets the attribute providerId.
     *
     * @param providerId value of providerId
     */
    void providerId(TeGlobalId providerId);

    /**
     * Sets the attribute clientId.
     *
     * @param clientId value of clientId
     */
    void clientId(TeGlobalId clientId);

    /**
     * Sets the attribute teTopologyId.
     *
     * @param teTopologyId value of teTopologyId
     */
    void teTopologyId(TeTopologyId teTopologyId);

    /**
     * Sets the attribute config.
     *
     * @param config value of config
     */
    void config(Config config);

    /**
     * Sets the attribute state.
     *
     * @param state value of state
     */
    void state(State state);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}