/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes;

/**
 * Represents the implementation of pathTiebreakerMaxfill.
 */
public abstract class PathTiebreakerMaxfill extends PathTiebreakerType {

    /**
     * Returns the attribute path-tiebreaker-maxfill.
     *
     * @return path-tiebreaker-maxfill value of path-tiebreaker-maxfill
     */
    public static String pathTiebreakerMaxfillToString() {
        return "path-tiebreaker-maxfill";
    }

    /**
     * Returns the object of pathTiebreakerMaxfill fromString input String pathTiebreakerMaxfill.
     *
     * @param valInString value of input String
     * @return pathTiebreakerMaxfill
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("path-tiebreaker-maxfill")) {
            return PathTiebreakerMaxfill.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}