/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes;

/**
 * Represents the implementation of routeUsageType.
 */
public abstract class RouteUsageType {

    /**
     * Returns the attribute route-usage-type.
     *
     * @return route-usage-type value of route-usage-type
     */
    public static String routeUsageTypeToString() {
        return "route-usage-type";
    }

    /**
     * Returns the object of routeUsageType fromString input String routeUsageType.
     *
     * @param valInString value of input String
     * @return routeUsageType
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("route-usage-type")) {
            return RouteUsageType.class;
        } else if (valInString.equals("route-include-ero")) {
            return RouteIncludeEro.class;
        } else if (valInString.equals("route-exclude-ero")) {
            return RouteExcludeEro.class;
        } else if (valInString.equals("route-exclude-srlg")) {
            return RouteExcludeSrlg.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}