/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes;

/**
 * Represents the implementation of switchingCapabilities.
 */
public abstract class SwitchingCapabilities {

    /**
     * Returns the attribute switching-capabilities.
     *
     * @return switching-capabilities value of switching-capabilities
     */
    public static String switchingCapabilitiesToString() {
        return "switching-capabilities";
    }

    /**
     * Returns the object of switchingCapabilities fromString input String switchingCapabilities.
     *
     * @param valInString value of input String
     * @return switchingCapabilities
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("switching-capabilities")) {
            return SwitchingCapabilities.class;
        } else if (valInString.equals("switching-psc1")) {
            return SwitchingPsc1.class;
        } else if (valInString.equals("switching-evpl")) {
            return SwitchingEvpl.class;
        } else if (valInString.equals("switching-l2sc")) {
            return SwitchingL2Sc.class;
        } else if (valInString.equals("switching-tdm")) {
            return SwitchingTdm.class;
        } else if (valInString.equals("switching-otn")) {
            return SwitchingOtn.class;
        } else if (valInString.equals("switching-dcsc")) {
            return SwitchingDcsc.class;
        } else if (valInString.equals("switching-lsc")) {
            return SwitchingLsc.class;
        } else if (valInString.equals("switching-fsc")) {
            return SwitchingFsc.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}