/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes;

/**
 * Represents the implementation of tunnelP2p.
 */
public abstract class TunnelP2p extends TunnelType {

    /**
     * Returns the attribute tunnel-p2p.
     *
     * @return tunnel-p2p value of tunnel-p2p
     */
    public static String tunnelP2pToString() {
        return "tunnel-p2p";
    }

    /**
     * Returns the object of tunnelP2p fromString input String tunnelP2p.
     *
     * @param valInString value of input String
     * @return tunnelP2p
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("tunnel-p2p")) {
            return TunnelP2p.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}