/*
 * Copyright 2019-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.tunnelpathaffinities.tunnelpathaffinities.style.named.constraints;

import java.util.List;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.tunnelpathaffinities.tunnelpathaffinities.style.named.constraints.constraint.AffinityNames;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of constraint.
 */
public interface Constraint extends Augmentable  {

    /**
     * Returns the attribute affinityNames.
     *
     * @return affinityNames list of affinityNames
     */
    List<AffinityNames> affinityNames();

    /**
     * Sets the attribute affinityNames.
     *
     * @param affinityNames list of affinityNames
     */
    void affinityNames(List<AffinityNames> affinityNames);

    /**
     * Adds to the list of affinityNames.
     *
     * @param addTo value of affinityNames
     */
    void addToAffinityNames(AffinityNames addTo);

}